<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Trusthub
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Trusthub\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class ComplianceInquiriesList extends ListResource
    {
    /**
     * Construct the ComplianceInquiriesList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/ComplianceInquiries/Customers/Initialize';
    }

    /**
     * Helper function for Create
     *
     * @param array|Options $options Optional Arguments
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'NotificationEmail' =>
                $options['notificationEmail'],
            'ThemeSetId' =>
                $options['themeSetId'],
            'PrimaryProfileSid' =>
                $options['primaryProfileSid'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the ComplianceInquiriesInstance
     *
     * @param array|Options $options Optional Arguments
     * @return ComplianceInquiriesInstance Created ComplianceInquiriesInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(array $options = []): ComplianceInquiriesInstance
    {
        $response = $this->_create($options);
        return new ComplianceInquiriesInstance(
            $this->version,
            $response->getContent()
        );
        
    }

    /**
     * Create the ComplianceInquiriesInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_create($options);
        $resource = new ComplianceInquiriesInstance(
                        $this->version,
                        $response->getContent()
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Constructs a ComplianceInquiriesContext
     *
     * @param string $customerId The unique CustomerId matching the Customer Profile/Compliance Inquiry that should be resumed or resubmitted. This value will have been returned by the initial Compliance Inquiry creation call.
     */
    public function getContext(
        string $customerId
        
    ): ComplianceInquiriesContext
    {
        return new ComplianceInquiriesContext(
            $this->version,
            $customerId
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Trusthub.V1.ComplianceInquiriesList]';
    }
}
