import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../wayfinder'
import settings from './settings'
import logo from './logo'
import hero from './hero'
import stats from './stats'
import features from './features'
import benefits from './benefits'
import useCases from './use-cases'
import pricing from './pricing'
import faqs from './faqs'
import footer from './footer'
/**
* @see \App\Http\Controllers\Admin\ThemeController::index
 * @see app/Http/Controllers/Admin/ThemeController.php:30
 * @route '/admin/theme'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/admin/theme',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Admin\ThemeController::index
 * @see app/Http/Controllers/Admin/ThemeController.php:30
 * @route '/admin/theme'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Admin\ThemeController::index
 * @see app/Http/Controllers/Admin/ThemeController.php:30
 * @route '/admin/theme'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\Admin\ThemeController::index
 * @see app/Http/Controllers/Admin/ThemeController.php:30
 * @route '/admin/theme'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\Admin\ThemeController::index
 * @see app/Http/Controllers/Admin/ThemeController.php:30
 * @route '/admin/theme'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\Admin\ThemeController::index
 * @see app/Http/Controllers/Admin/ThemeController.php:30
 * @route '/admin/theme'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\Admin\ThemeController::index
 * @see app/Http/Controllers/Admin/ThemeController.php:30
 * @route '/admin/theme'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
const theme = {
    index: Object.assign(index, index),
settings: Object.assign(settings, settings),
logo: Object.assign(logo, logo),
hero: Object.assign(hero, hero),
stats: Object.assign(stats, stats),
features: Object.assign(features, features),
benefits: Object.assign(benefits, benefits),
useCases: Object.assign(useCases, useCases),
pricing: Object.assign(pricing, pricing),
faqs: Object.assign(faqs, faqs),
footer: Object.assign(footer, footer),
}

export default theme